/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import io.neox.neonium.Neonium;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.BlockColorSettings;
import me.jellysquid.mods.sodium.client.model.quad.blender.FlatBiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.SmoothBiomeColorBlender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

class ConfigurableColorBlender
implements BiomeColorBlender {
    private final BiomeColorBlender defaultBlender = new FlatBiomeColorBlender();
    private final BiomeColorBlender smoothBlender = ConfigurableColorBlender.isSmoothBlendingEnabled() ? new SmoothBiomeColorBlender() : this.defaultBlender;

    public ConfigurableColorBlender(Minecraft client) {
    }

    private static boolean isSmoothBlendingEnabled() {
        return Neonium.options().quality.biomeBlendRadius > 0;
    }

    @Override
    public int[] getColors(IBlockColor colorizer, IBlockAccess world, IBlockState state, BlockPos origin, ModelQuadView quad) {
        BiomeColorBlender blender = BlockColorSettings.isSmoothBlendingEnabled(world, state, origin) ? this.smoothBlender : this.defaultBlender;
        return blender.getColors(colorizer, world, state, origin, quad);
    }
}

